/**
 * 
 */
package gov.va.med.mhv.usermgmt.web.converter;

import org.springframework.core.convert.converter.Converter;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.usermgmt.web.formbean.UserProfile;

/**
 * @author vhaislegberb
 *
 */
public class UserProfileDTOConverter implements Converter<UserProfileDTO, UserProfile> {

	@Override
	public UserProfile convert(UserProfileDTO src) {
		UserProfile target = new UserProfile();
		
		target.setAcceptDisclaimer(src.getAcceptDisclaimer());
		target.setAcceptPrivacy(src.getAcceptPrivacy());
		target.setAcceptSMTerms(src.getAcceptSMTerms());
		target.setAcceptTerms(src.getAcceptTerms());
		target.setAccessRoles(src.getAccessRoles());
		target.setAccountType(src.getAccountType());
		target.setAddress(src.getAddress());
		target.setAddressState(src.getAddressState());
		target.setAlternateAddress(src.getAlternateAddress());
		target.setAlternateAddressCity(src.getAlternateAddressCity());
		target.setAlternateAddressCountry(src.getAlternateAddressCountry());
		target.setAlternateAddressPostalCode(src.getAlternateAddressPostalCode());
		target.setAlternateAddressProvince(src.getAlternateAddressProvince());
		target.setAlternateAddressState(src.getAlternateAddressState());
		target.setAlternateAddressStreet1(src.getAlternateAddressStreet1());
		target.setAlternateAddressStreet2(src.getAlternateAddressStreet2());
		target.setApptReminderEmailPref(src.getApptReminderEmailPref());
		if (src.getBbmiEmailPref() != null) {
			target.setBbmiEmailPref(src.getBbmiEmailPref());
		}	
		target.setAutoAuth(src.getAutoAuth());
		target.setAutoAuthDate(src.getAutoAuthDate());
		target.setBirthDate(src.getBirthDate());
		target.setBloodType(src.getBloodType());
		target.setIsChampVABeneficiary(src.getIsChampVABeneficiary());
		target.setConfEmail(src.getConfEmail());
		target.setConfirmationLockOut(src.getConfirmationLockOut());
		target.setConfPassword(src.getConfPassword());
		target.setConfSsn(src.getConfSsn());
		target.setConfSsn3(target.getSsnCnfThree());
		target.setConfSsn2(target.getSsnCnfTwo());
		target.setConfSsn4(target.getSsnCnfFour());
		target.setContact(src.getContact());
		target.setCreatedDate(src.getCreatedDate());
		target.setCurrentLogin(src.getCurrentLogin());
		target.setCurrentOccupation(src.getCurrentOccupation());
		target.setDeathDate(src.getDeathDate());
		target.setEhrAccess(src.getEhrAccess());
		target.setEmailCredentials(src.getEmailCredentials());
		target.setEmailHealthAwareness(src.getEmailHealthAwareness());
		target.setEmergencyContacts(src.getEmergencyContacts());
		target.setFccx(src.getFccx());
		target.setFirstName(src.getFirstName());
		target.setGender(src.getGender());
		target.setHealthSummarySentEmailPref(src.getHealthSummarySentEmailPref());
		target.setId(src.getId());
		target.setInfoMessage(src.getInfoMessage());
		target.setInterestAlcohol(src.getInterestAlcohol());
		target.setInterestBloodPressure(src.getInterestBloodPressure());
		target.setInterestDepression(src.getInterestDepression());
		target.setInterestDiabetes(src.getInterestDiabetes());
		target.setInterestDiet(src.getInterestDiet());
		target.setInterestExercise(src.getInterestExercise());
		target.setInterestHeart(src.getInterestHeart());
		target.setInterestMilitaryRelated(src.getInterestMilitaryRelated());
		target.setInterestPTSD(src.getInterestPTSD());
		target.setInterestReminder(src.getInterestReminder());
		target.setInterestSmoking(src.getInterestSmoking());
		target.setInterestStress(src.getInterestStress());
		target.setIsAdministrator(src.getIsAdministrator());
		target.setIsEmployee(src.getIsEmployee());
		target.setIsHealthCareProvider(src.getIsHealthCareProvider());
		target.setIsMPIControlled(src.getIsMPIControlled());
		target.setIsOrganDonor(src.getIsOrganDonor());
		target.setIsOther(src.getIsOther());
		target.setIsPatient(src.getIsPatient());
		target.setIsPatientAdvocate(src.getIsPatientAdvocate());
		target.setIsVeteran(src.getIsVeteran());
		target.setIsChampVABeneficiary(src.getIsChampVABeneficiary());
		target.setIsServiceMember(src.getIsServiceMember());
		target.setLastLogin(src.getLastLogin());
		target.setLastName(src.getLastName());
		target.setLockCount(src.getLockCount());
		target.setLockDate(src.getLockDate());
		target.setMaritalStatus(src.getMaritalStatus());
		target.setMhvId(src.getMhvId());
		target.setModifiedDate(src.getModifiedDate());
		target.setName(src.getName());
		target.setOccupation(src.getOccupation());
		target.setOldPassword(src.getOldPassword());
		target.setOplock(src.getOplock());
		target.setOrganDonor(src.getOrganDonor());
		target.setOrientationVideoView(src.getOrientationVideoView());
		target.setParticipationFormSign(src.getParticipationFormSign());
		target.setPassword(src.getPassword());
		target.setPasswordHintAnswer1(src.getPasswordHintAnswer1());
		target.setPasswordHintAnswer2(src.getPasswordHintAnswer2());
		target.setPasswordHintQuestion1(src.getPasswordHintQuestion1());
		target.setPasswordHintQuestion2(src.getPasswordHintQuestion2());
		target.setPasswordLastChanged(src.getPasswordLastChanged());
		target.setPasswordLockOut(src.getPasswordLockOut());
		target.setPhysicalProof(src.getPhysicalProof());
		target.setProofInstitutionId(src.getProofInstitutionId());
		target.setProofLevel(src.getProofLevel());
		target.setProofLevelDate(src.getProofLevelDate());
		target.setRestrictSIPAccess(src.getRestrictSIPAccess());
		target.setRestrictSIPAccessBy(src.getRestrictSIPAccessBy());
		target.setRestrictSIPAccessDate(src.getRestrictSIPAccessDate());
		target.setRestrictSIPAccessReason(src.getRestrictSIPAccessReason());
		target.setRxAgreementDate(src.getRxAgreementDate());
		target.setRxAgreementSigned(src.getRxAgreementSigned());
		target.setRxTrackingEmailPref(src.getRxTrackingEmailPref());
		target.setSsn(src.getSsn());
		target.setSsn3(target.getSsnThree());
		target.setSsn2(target.getSsnTwo());
		target.setSsn4(target.getSsnFour());
		target.setTemporaryPassword(src.getTemporaryPassword());
		target.setTermsModifiedTime(src.getTermsModifiedTime());
		target.setUserAlias(src.getUserAlias());
		target.setUserName(src.getUserName());
		
		return target;
	}
}
